﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace PI.ZB.N1200.ELearning.BL.APIMobile.Model
{
    /// <summary>
    /// Narzedzia konwersji daty UNIX na DateTime i we w drugą stronę
    /// </summary>
    public static class GUtils
    {
        private static readonly DateTime unixStartDate = new DateTime(1970, 1, 1, 0, 0, 0, DateTimeKind.Utc);

        /// <summary>
        /// Converts a <see cref="DateTime"/> object into a unix timestamp number.
        /// </summary>
        /// <param name="date">The date to convert.</param>
        /// <returns>A long for the number of seconds since 1st January 1970, as per unix specification.</returns>
        internal static long DateToUnixTimestamp(DateTime date)
        {
            TimeSpan ts = date - unixStartDate;
            return (long)ts.TotalSeconds;
        }

        /// <summary>
        /// Converts a string, representing a unix timestamp number into a <see cref="DateTime"/> object.
        /// </summary>
        /// <param name="timestamp">The timestamp, as a string.</param>
        /// <returns>The <see cref="DateTime"/> object the time represents.</returns>
        internal static DateTime UnixTimestampToDate(string timestamp)
        {
            if (timestamp == null || timestamp.Length == 0) return DateTime.MinValue;

            return UnixTimestampToDate(long.Parse(timestamp));
        }

        /// <summary>
        /// Converts a <see cref="long"/>, representing a unix timestamp number into a <see cref="DateTime"/> object.
        /// </summary>
        /// <param name="timestamp">The unix timestamp.</param>
        /// <returns>The <see cref="DateTime"/> object the time represents.</returns>
        internal static DateTime UnixTimestampToDate(long timestamp)
        {
            return unixStartDate.AddSeconds(timestamp);
        }
    }
}